/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import jclass.table3.Chain;
import jclass.table3.Clip;
import jclass.table3.JCCell;
import jclass.table3.Series;
import jclass.table3.Table;

class Size {
    static final int DELETECOLUMNS = 1;
    static final int DELETEROWS = 2;
    static final int INSERTCOLUMNS = 3;
    static final int INSERTROWS = 4;
    static final int MOVECOLUMNS = 5;
    static final int MOVEROWS = 6;
    static final int RESET = 7;
    private static final int NOTFOUND = -900;

    static int getFontHeight(Table table, int n, int n2) {
        Font font = table.getFont(n, n2);
        if (font == null) {
            return 0;
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font).getHeight();
    }

    static int getFontWidth(Table table, int n, int n2) {
        Font font = table.getFont(n, n2);
        if (font == null) {
            return 0;
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font).charWidth('W');
    }

    static void setDimensions(Table table, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        if (!table.repaint) {
            table.needs_recalc = true;
            return;
        }
        if (n4 == -998) {
            n4 = 0;
            n5 = table.rows;
        }
        if (n6 == -998) {
            n6 = 0;
            n7 = table.columns;
        }
        switch (n) {
            case 7: {
                table.row_heights = new Chain(table.rows);
                table.column_widths = new Chain(table.columns);
                if (table.columns != 0) {
                    table.column_widths = new Chain(table.columns);
                    Size.getColumnWidths(table, -998, 0, -998, 0, null);
                    Size.getCellTotalWidth(table);
                } else {
                    table.cell_total_width = 0;
                }
                if (table.rows != 0) {
                    Size.getRowHeights(table, -998, 0, -998, 0, null);
                    Size.getCellTotalHeight(table);
                    return;
                }
                table.cell_total_height = 0;
                return;
            }
            case 2: 
            case 4: {
                if (n == 4) {
                    Chain chain = new Chain();
                    Size.getRowHeights(table, n4, n4 + n5 - 1, n6, n6 + n7 - 1, chain);
                    table.row_label_width = Size.getRowLabelMaxWidth(table, n4, n4 + n5 - 1);
                    table.row_heights.insert(chain, n4);
                } else if (n == 2) {
                    table.row_heights.delete(n4, n4 + n5 - 1);
                    table.row_label_width = Size.getRowLabelMaxWidth(table, -998, 0);
                }
                Size.getCellTotalHeight(table);
                if (bl) {
                    Size.getColumnWidths(table, n4, n4 + n5 - 1, n6, n6 + n7 - 1, null);
                    Size.getCellTotalWidth(table);
                }
                return;
            }
            case 1: 
            case 3: {
                if (n == 3) {
                    Chain chain = new Chain();
                    Size.getColumnWidths(table, n4, n4 + n5 - 1, n6, n6 + n7 - 1, chain);
                    table.column_label_height = Size.getColumnLabelMaxHeight(table, n6, n6 + n7 - 1);
                    table.column_widths.insert(chain, n6);
                } else if (n == 1) {
                    table.column_widths.delete(n6, n6 + n7 - 1);
                    table.column_label_height = Size.getColumnLabelMaxHeight(table, -998, 0);
                }
                Size.getCellTotalWidth(table);
                Size.getRowHeights(table, n4, n4 + n5 - 1, n6, n6 + n7 - 1, null);
                Size.getCellTotalHeight(table);
                return;
            }
        }
    }

    static void getCellTotalWidth(Table table) {
        if (!table.repaint) {
            table.needs_recalc = true;
            return;
        }
        if (table.columns > 0) {
            table.cell_total_width = table.columnPosition(table.columns - 1) + table.columnWidth(table.columns - 1) - table.frozenColumnWidth();
            return;
        }
        table.cell_total_width = 0;
    }

    static void getCellTotalHeight(Table table) {
        if (!table.repaint) {
            table.needs_recalc = true;
            return;
        }
        if (table.rows > 0) {
            table.cell_total_height = table.rowPosition(table.rows - 1) + table.rowHeight(table.rows - 1) - table.frozenRowHeight();
            return;
        }
        table.cell_total_height = 0;
    }

    static boolean compute(Table table, boolean bl, boolean bl2) {
        int n;
        int n2;
        if (!table.repaint) {
            table.needs_recalc = true;
            return false;
        }
        int n3 = 0;
        int n4 = 0;
        if (table.visible_columns > 0) {
            n2 = 0;
            n = Math.min(table.getNumColumns(), table.visible_columns);
            if (n <= table.columns - table.frozen_columns) {
                n2 = table.frozen_columns + n - 1;
                n3 = table.columnPosition(n2) + table.columnWidth(n2);
            }
            if (n3 == 0) {
                if (table.columns > 0) {
                    n2 = table.columns - 1;
                    n3 = table.columnPosition(n2) + table.columnWidth(n2);
                }
                if (n3 == 0) {
                    n2 = -1;
                }
                n3 += Size.getColumnWidth(table, n2 + 1, n);
            }
            n3 += table.rowLabelWidth() + table.rowLabelExtraWidth() + 2 * table.frame_shadow;
            if (table.hasVertSB()) {
                n3 += table.vertSBwidth();
            }
        } else if (bl) {
            n3 = table.cell_total_width + table.frozenColumnWidth() + table.rowLabelWidth() + table.rowLabelExtraWidth() + (table.columns > 0 ? 2 * table.frame_shadow : 0);
            if (table.hasVertSB()) {
                n3 += table.vertSBwidth();
            }
        } else {
            int n5 = n3 = table.containerWidth() > 0 ? table.containerWidth() : table.desired_width;
        }
        if (table.visible_rows > 0) {
            n2 = 0;
            n = Math.min(table.getNumRows(), table.visible_rows);
            if (n <= table.rows - table.frozen_rows) {
                n2 = table.frozen_rows + n - 1;
                n4 = table.rowPosition(n2) + table.rowHeight(n2);
            }
            if (n4 == 0) {
                if (table.rows > 0) {
                    n2 = table.rows - 1;
                    n4 = table.rowPosition(n2) + table.rowHeight(n2);
                }
                if (n4 == 0) {
                    n2 = -1;
                }
                n4 += Size.getRowHeight(table, n2 + 1, n);
            }
            n4 += table.columnLabelHeight() + table.colLabelExtraHeight() + 2 * table.frame_shadow;
            if (table.hasHorizSB()) {
                n4 += table.horizSBheight();
            }
        } else if (bl2) {
            n4 = table.cell_total_height + table.frozenRowHeight() + table.columnLabelHeight() + table.colLabelExtraHeight() + (table.rows > 0 ? 2 * table.frame_shadow : 0);
            if (table.hasHorizSB()) {
                n4 += table.horizSBheight();
            }
        } else {
            n4 = table.containerHeight() > 0 ? table.containerHeight() : table.desired_height;
        }
        table.desired_width = n3;
        table.desired_height = n4;
        return true;
    }

    static int getSingleValue(Series series, boolean bl) {
        Object object = null;
        if (series.size() == 1) {
            object = series.getDefault();
        } else if (series.size() == 2) {
            int n;
            int n2 = bl ? -998 : -997;
            int n3 = series.findExact(n2, n = bl ? -997 : -998);
            if (n3 != -999) {
                object = series.getValue(n3);
            } else {
                n2 = bl ? -998 : -1;
                n3 = series.findExact(n2, n = bl ? -1 : -998);
                if (n3 != -999) {
                    object = series.getDefault();
                }
            }
        }
        if (object != null) {
            return (Integer)object;
        }
        return -900;
    }

    static int getQuickSize(Series series, Series series2, int n, int n2, boolean bl) {
        int n3 = -900;
        int n4 = Size.getSingleValue(series, bl);
        if (n4 != -999) {
            return n4;
        }
        n3 = Size.getSingleValue(series2, bl);
        if (n3 != -900) {
            return n3 * n + n2;
        }
        return -900;
    }

    static void getColumnWidths(Table table, int n, int n2, int n3, int n4, Chain chain) {
        int n5;
        if (!table.repaint) {
            table.needs_recalc = true;
            return;
        }
        boolean bl = chain == null;
        int n6 = 2 * table.textWidthOffset();
        int n7 = 0;
        boolean bl2 = false;
        int n8 = -999;
        int n9 = -999;
        int n10 = -999;
        int n11 = -999;
        if (table.columns == 0) {
            return;
        }
        if (n3 >= table.columns) {
            return;
        }
        if (n == 0 && n2 == table.rows - 1) {
            bl2 = true;
        } else if (n == -998) {
            bl2 = true;
            n = 0;
            n2 = table.rows - 1;
        }
        if (n3 == -998) {
            n3 = 0;
            n4 = table.columns - 1;
        } else {
            n4 = Math.min(n4, table.columns - 1);
        }
        if (bl && (n5 = Size.getQuickSize(table.pixelwidth_series, table.charwidth_series, Size.getFontWidth(table, -998, -998), n6, true)) >= 0 && n5 != 33001 && n5 != 33002 && n5 != 33000) {
            table.column_widths.setValue(n3, n4, n5);
            return;
        }
        int n12 = n3;
        while (n12 <= n4) {
            n5 = table.getPixelWidth(n12);
            if (bl && n5 == 33000) {
                n5 = table.columnWidth(n12);
                if (n5 <= 0) {
                    n5 = table.getCharWidth(n12) * Size.getFontWidth(table, -997, n12) + n6;
                }
            } else if (n5 == -999 || !bl && n5 == 33000) {
                n5 = table.getCharWidth(n12) * Size.getFontWidth(table, -997, n12) + n6;
            } else if (n5 == 33001) {
                n5 = Size.calcLargestWidth(table, -1, table.rows - 1, n12, 0);
            } else if (n5 == 33002) {
                n5 = table.estimate_count == -998 || table.estimate_count == -997 || table.estimate_count == Integer.MAX_VALUE ? Size.calcLargestWidth(table, -1, table.rows - 1, n12, 0) : Size.calcLargestWidth(table, -1, table.estimate_count, n12, 0);
            }
            n9 = n5;
            n8 = n12;
            if (bl) {
                int n13;
                if (n11 == -999) {
                    n11 = n13 = n9;
                    n10 = n7 = n8;
                } else if (n11 != n9) {
                    table.column_widths.setValue(n10, n7, n11);
                    n10 = n7 = n8;
                    n11 = n13 = n9;
                } else {
                    n7 = n8;
                    n13 = n9;
                }
            } else {
                chain.append(n9);
            }
            ++n12;
        }
        if (n9 != -999 && bl) {
            table.column_widths.setValue(n10, n7, n11);
        }
    }

    private static int getRowHeight(Table table, int n, int n2) {
        int n3 = 0;
        int n4 = 2 * table.textHeightOffset();
        int n5 = n;
        while (n5 <= n2) {
            int n6 = table.getPixelHeight(n5);
            if (n6 == -999 || n6 == 33000) {
                n6 = table.getCharHeight(n5) * Size.getFontHeight(table, n5, -997) + n4;
            } else if (n6 == 33001) {
                n6 = Size.calcLargestHeight(table, n5, -1, table.columns - 1, 0);
                if (n6 == 0) {
                    n6 = table.getCharHeight(n5) * Size.getFontHeight(table, n5, -997) + n4;
                }
            } else if (n6 == 33002 && (n6 = table.estimate_count == -998 || table.estimate_count == -997 || table.estimate_count == Integer.MAX_VALUE ? Size.calcLargestHeight(table, n5, -1, table.columns - 1, 0) : Size.calcLargestHeight(table, n5, -1, table.estimate_count, 0)) == 0) {
                n6 = table.getCharHeight(n5) * Size.getFontHeight(table, n5, -997) + n4;
            }
            n3 += n6;
            ++n5;
        }
        return n3;
    }

    private static int getColumnWidth(Table table, int n, int n2) {
        int n3 = 0;
        int n4 = 2 * table.textWidthOffset();
        int n5 = n;
        while (n5 <= n2) {
            int n6 = table.getPixelWidth(n5);
            if (n6 == -999 || n6 == 33000) {
                n6 = table.getCharWidth(n5) * Size.getFontWidth(table, -997, n5) + n4;
            } else if (n6 == 33001) {
                n6 = Size.calcLargestWidth(table, -1, table.rows - 1, n5, 0);
                if (n6 == 0) {
                    n6 = table.getCharWidth(n5) * Size.getFontWidth(table, -997, n5) + n4;
                }
            } else if (n6 == 33002 && (n6 = table.estimate_count == -998 || table.estimate_count == -997 || table.estimate_count == Integer.MAX_VALUE ? Size.calcLargestWidth(table, -1, table.rows - 1, n5, 0) : Size.calcLargestWidth(table, -1, table.estimate_count, n5, 0)) == 0) {
                n6 = table.getCharWidth(n5) * Size.getFontWidth(table, -997, n5) + n4;
            }
            n3 += n6;
            ++n5;
        }
        return n3;
    }

    static void getRowHeights(Table table, int n, int n2, int n3, int n4, Chain chain) {
        int n5;
        if (!table.repaint) {
            table.needs_recalc = true;
            return;
        }
        boolean bl = chain == null;
        int n6 = 2 * table.textHeightOffset();
        int n7 = 0;
        boolean bl2 = false;
        int n8 = -999;
        int n9 = -999;
        int n10 = -999;
        int n11 = -999;
        if (table.rows == 0) {
            return;
        }
        if (n >= table.rows) {
            return;
        }
        if (n3 == 0 && n4 == table.columns - 1) {
            bl2 = true;
        } else if (n3 == -998) {
            bl2 = true;
            n3 = 0;
            n4 = table.columns - 1;
        }
        if (n == -998) {
            n = 0;
            n2 = table.rows - 1;
        } else {
            n2 = Math.min(n2, table.rows - 1);
        }
        if (bl && (n5 = Size.getQuickSize(table.pixelheight_series, table.charheight_series, Size.getFontHeight(table, -998, -998), n6, false)) >= 0 && n5 != 33001 && n5 != 33002 && n5 != 33000) {
            table.row_heights.setValue(n, n2, n5);
            return;
        }
        int n12 = n;
        while (n12 <= n2) {
            n5 = table.getPixelHeight(n12);
            if (bl && n5 == 33000) {
                n5 = table.rowHeight(n12);
                if (n5 <= 0) {
                    n5 = table.getCharHeight(n12) * Size.getFontHeight(table, n12, -997) + n6;
                }
            } else if (n5 == -999 || !bl && n5 == 33000) {
                n5 = table.getCharHeight(n12) * Size.getFontHeight(table, n12, -997) + n6;
            } else if (n5 == 33001) {
                n5 = Size.calcLargestHeight(table, n12, -1, table.columns - 1, 0);
            } else if (n5 == 33002) {
                n5 = table.estimate_count == -998 || table.estimate_count == -997 || table.estimate_count == Integer.MAX_VALUE ? Size.calcLargestHeight(table, n12, -1, table.columns - 1, 0) : Size.calcLargestHeight(table, n12, -1, table.estimate_count, 0);
            }
            n9 = n5;
            n8 = n12;
            if (bl) {
                int n13;
                if (n11 == -999) {
                    n11 = n13 = n9;
                    n10 = n7 = n8;
                } else if (n11 != n9) {
                    table.row_heights.setValue(n10, n7, n11);
                    n11 = n13 = n9;
                    n10 = n7 = n8;
                } else {
                    n7 = n8;
                    n13 = n9;
                }
            } else {
                chain.append(n9);
            }
            ++n12;
        }
        if (n9 != -999 && bl) {
            table.row_heights.setValue(n10, n7, n11);
        }
    }

    private static boolean hasValue(Table table, int n, int n2) {
        Component component = table.getComponent(n, n2);
        return component != null || table.dataView.getData(n, n2) != null;
    }

    static int getColumnLabelMaxHeight(Table table, int n, int n2) {
        if (!table.repaint) {
            table.needs_recalc = true;
            return 0;
        }
        int n3 = table.textHeightOffset() * 2;
        int n4 = 0;
        if (table.columns == 0) {
            return 0;
        }
        if (n == -998) {
            n = 0;
            n2 = table.columns - 1;
        } else {
            n4 = table.column_label_height;
        }
        int n5 = table.getPixelHeight(-1);
        if (n4 <= 0 && n5 > 0 && n5 != 33001 && n5 != 33002 && n5 != 33000) {
            n4 = n5;
        }
        if (!table.column_label_display) {
            return 0;
        }
        if (n5 == 33000) {
            if (table.column_label_height <= 0) {
                return Math.max(n4, table.getCharHeight(-1) * Size.getFontHeight(table, -1, -998));
            }
            return Math.max(n4, table.column_label_height);
        }
        if (!table.hasComponents() && !table.column_label_display) {
            return n4;
        }
        if (n5 == -999 && !table.hasComponents()) {
            return Math.max(n4, table.getCharHeight(-1) * Size.getFontHeight(table, -1, -998));
        }
        if (n5 != 33001 && n5 != 33002 && !Size.hasCellComponents(table)) {
            return Math.max(1, n5 - n3);
        }
        int n6 = n;
        while (n6 <= n2) {
            if (Size.hasValue(table, -1, n6)) {
                n4 = Math.max(n4, Size.calcLargestHeight(table, -1, n6, n6, 0));
            }
            ++n6;
        }
        return n4;
    }

    static int getRowLabelMaxWidth(Table table, int n, int n2) {
        if (!table.repaint) {
            table.needs_recalc = true;
            return 0;
        }
        int n3 = table.textWidthOffset() * 2;
        int n4 = 0;
        if (table.rows == 0) {
            return 0;
        }
        if (n == -998) {
            n = 0;
            n2 = table.rows - 1;
        } else {
            n4 = table.row_label_width;
        }
        int n5 = table.getPixelWidth(-1);
        if (n4 <= 0 && n5 > 0 && n5 != 33001 && n5 != 33002 && n5 != 33000) {
            n4 = n5;
        }
        if (!table.row_label_display) {
            return 0;
        }
        if (n5 == 33000) {
            if (table.row_label_width <= 0) {
                return Math.max(n4, table.getCharWidth(-1) * Size.getFontWidth(table, -998, -1));
            }
            return Math.max(n4, table.row_label_width);
        }
        if (!table.hasComponents() && !table.row_label_display) {
            return n4;
        }
        if (n5 == -999 && !table.hasComponents()) {
            return Math.max(n4, table.getCharWidth(-1) * Size.getFontWidth(table, -998, -1));
        }
        if (n5 != 33001 && n5 != 33002 && !Size.hasCellComponents(table)) {
            return Math.max(1, n5 - n3);
        }
        int n6 = n;
        while (n6 <= n2) {
            if (Size.hasValue(table, n6, -1)) {
                n4 = Math.max(n4, Size.calcLargestWidth(table, n6, n6, -1, 0));
            }
            ++n6;
        }
        return n4;
    }

    static boolean hasCellComponents(Table table) {
        return table.hasComponents() && !Size.hasLabelComponents(table);
    }

    static boolean hasLabelComponents(Table table) {
        Clip clip = Clip.find_by_type(table, 4);
        if (clip != null && clip.countComponents() > 0) {
            return true;
        }
        clip = Clip.find_by_type(table, 5);
        if (clip != null && clip.countComponents() > 0) {
            return true;
        }
        clip = Clip.find_by_type(table, 6);
        if (clip != null && clip.countComponents() > 0) {
            return true;
        }
        clip = Clip.find_by_type(table, 7);
        return clip != null && clip.countComponents() > 0;
    }

    static int calcLargestHeight(Table table, int n, int n2, int n3, int n4) {
        int n5 = n == -1 ? 0 : 2 * table.textHeightOffset();
        int n6 = 2 * table.shadow_thickness + 1;
        int n7 = n2;
        while (n7 <= n3 && n7 < table.columns) {
            if (!table.span.doSpansExist() || !table.span.isSpanned(n, n7)) {
                int n8;
                Object object = table.getComponent(n, n7);
                if (object == null) {
                    object = table.dataView.getData(n, n7);
                }
                if ((n8 = JCCell.getHeight(table, null, object, n, n7, table.getFont(n, n7))) > 0) {
                    n4 = Math.max(n4, n8 + (object instanceof Component ? n6 : n5));
                }
            }
            ++n7;
        }
        return n4;
    }

    static int calcLargestWidth(Table table, int n, int n2, int n3, int n4) {
        int n5 = n3 == -1 ? 0 : 2 * table.textWidthOffset();
        int n6 = 2 * table.shadow_thickness + 1;
        int n7 = n;
        while (n7 <= n2 && n7 < table.rows) {
            if (!table.span.doSpansExist() || !table.span.isSpanned(n7, n3)) {
                int n8;
                Object object = table.getComponent(n7, n3);
                if (object == null) {
                    object = table.dataView.getData(n7, n3);
                }
                if ((n8 = JCCell.getWidth(table, null, object, n7, n3, table.getFont(n7, n3))) > 0) {
                    n4 = Math.max(n4, n8 + (object instanceof Component ? n6 : n5));
                }
            }
            ++n7;
        }
        return n4;
    }

    Size() {
    }
}

